%gui_selections

SoundDir_gotten = 0; % uigetdir and uigetfile return "0" if the cancel button is pressed

while SoundDir_gotten == 0
    
    %blurb
    text(-0.05,1,'SoundLabeller', 'FontName','Times', 'Fontsize',30, 'Units','normalized', 'HorizontalAlignment','left', 'VerticalAlignment','top');
    text(-0.05,0.025,'Release 2011-04-03', 'FontName','Times', 'Fontsize',10, 'Units','normalized', 'HorizontalAlignment','left', 'VerticalAlignment','top');
    text(-0.05,0,' Geoffrey Stewart Morrison', 'FontName','Times', 'Fontsize',10, 'Units','normalized', 'HorizontalAlignment','left', 'VerticalAlignment','top');
    text(-0.05,-0.025,'http://geoff-morrison.net', 'FontName','Times', 'Fontsize',10, 'Units','normalized', 'HorizontalAlignment','left', 'VerticalAlignment','top');
    axis off

    Bgroup_file_options = uibuttongroup('Title','File Options',...
                            'FontSize',12,...
                            'Units','normalized',...
                            'Position',[.1 .7 .375 .15]);
    B_process_dir = uicontrol('Style','Radio',...
                            'String','Process all the files in a directory',...
                            'Value',process_dir,...
                            'Units','normalized',...
                            'Position',[.05 .7 .9 .25],...
                            'Parent', Bgroup_file_options);
    B_process_file = uicontrol('Style','Radio',...
                            'String','Process a single file',...
                            'Value',~process_dir,...
                            'Units','normalized',...
                            'Position',[.05 .45 .9 .25],...
                            'Parent', Bgroup_file_options);
    P_file_filter = uipanel(Bgroup_file_options, 'Title', 'File filter', 'Position', [.05 .1 .9 .3], 'BorderType', 'none');
    B_file_filter = uicontrol('Style','Edit',...
                            'String',FileFilter,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_file_filter);
    

    % precalculate spectrogram options
    precalc_Bgroup=uibuttongroup('Title','Calculation Options',...
                            'FontSize',12,...
                            'Units','normalized',...
                            'Position',[.1 .55 .375 .1]);
    precalc_specrogramsB = uicontrol('Style','Radio',...
                            'String','Precalculate the spectrogram before presenting the sound files for markup.',...
                            'Value',precalc_specrograms,...
                            'Units','normalized',...
                            'Position',[.05 .5 .9 .35],...
                            'Parent', precalc_Bgroup);
    ondemand_spectrogramsB = uicontrol('Style','Radio',...
                            'String','Calculate spectrograms on demand.',...
                            'Value',~precalc_specrograms,...
                            'Units','normalized',...
                            'Position',[.05 .1 .9 .35],...
                            'Parent', precalc_Bgroup);
                        
                        
    % miscellaneous options
    other_optionsBgroup=uibuttongroup('Title','Other Options',...
                            'FontSize',12,...
                            'Units','normalized',...
                            'Position',[.1 .3 .375 .2]);
    requested_num_markers_text = uicontrol('Style','Text',...
                            'String','Requested number of markers per sound file:',...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .75 .75 .2],...
                            'HorizontalAlignment', 'left',...
                            'Parent', other_optionsBgroup);
    requested_num_markersB = uicontrol('Style','Edit',...
                            'String',requested_num_markers_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.8 .75 .15 .2],...
                            'Parent', other_optionsBgroup);
    num_marker_rows_text = uicontrol('Style','Text',...
                            'String','Number of rows of markers:',...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .5 .75 .2],...
                            'HorizontalAlignment', 'left',...
                            'Parent', other_optionsBgroup);
    num_marker_rowsB = uicontrol('Style','Edit',...
                            'String',num_marker_rows_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.8 .5 .15 .2],...
                            'Parent', other_optionsBgroup);
    allow_textlabelsB = uicontrol('Style','Check',...
                            'String','Allow input of text labels',...
                            'Value',allow_textlabels,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .25 .9 .2],...
                            'Parent', other_optionsBgroup);
    review_onlyB = uicontrol('Style','Check',...
                            'String','Review already-saved markers only',...
                            'Value',review_only,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .05 .9 .2],...
                            'Parent', other_optionsBgroup);
                        
                        

    % spectrogram options
    spectro_optionsBgroup=uibuttongroup('Title','Spectrogram Options',...
                            'FontSize',12,...
                            'Units','normalized',...
                            'Position',[.525 .45 .25 .4]);
    nyquist_text = uicontrol('Style','Text',...
                            'String','Nyquist frequency (Hz):',...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .85 .75 .075],...
                            'HorizontalAlignment', 'left',...
                            'Parent', spectro_optionsBgroup);
    nyquistB = uicontrol('Style','Edit',...
                            'String',nyquist_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.8 .85 .15 .075],...
                            'Parent', spectro_optionsBgroup);
    premph_text = uicontrol('Style','Text',...
                            'String','Pre-emphasis:',...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .75 .75 .075],...
                            'HorizontalAlignment', 'left',...
                            'Parent', spectro_optionsBgroup);
    premphB = uicontrol('Style','Edit',...
                            'String',premph_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.8 .75 .15 .075],...
                            'Parent', spectro_optionsBgroup);
    window_length_ms_text = uicontrol('Style','Text',...
                            'String','Window length (ms):',...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .65 .75 .075],...
                            'HorizontalAlignment', 'left',...
                            'Parent', spectro_optionsBgroup);
    window_length_msB = uicontrol('Style','Edit',...
                            'String',window_length_ms_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.8 .65 .15 .075],...
                            'Parent', spectro_optionsBgroup);
    window_shift_ms_text = uicontrol('Style','Text',...
                            'String','Window shift (ms):',...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .55 .75 .075],...
                            'HorizontalAlignment', 'left',...
                            'Parent', spectro_optionsBgroup);
    window_shift_msB = uicontrol('Style','Edit',...
                            'String',window_shift_ms_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.8 .55 .15 .075],...
                            'Parent', spectro_optionsBgroup);
    colour_compression_text = uicontrol('Style','Text',...
                            'String','Amplitude display floor (proportion):',...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .45 .75 .075],...
                            'HorizontalAlignment', 'left',...
                            'Parent', spectro_optionsBgroup);
    colour_compressionB = uicontrol('Style','Edit',...
                            'String',colour_compression_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.8 .45 .15 .075],...
                            'Parent', spectro_optionsBgroup);
    smooth_spectroB = uicontrol('Style','Check',...
                            'String','Smooth Spectrograms',...
                            'Value',smooth_spectrograms,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .35 .9 .075],...
                            'Parent', spectro_optionsBgroup);
    spectro_colormap_text = uicontrol('Style','Text',...
                            'String','Colours:',...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .25 .75 .075],...
                            'HorizontalAlignment', 'left',...
                            'Parent', spectro_optionsBgroup);
    spectro_colormap_indexB = uicontrol('Style','Listbox',...
                            'String',colormap_options(:,1),...
                            'Value',spectro_colormap_index,...
                            'Max',0,'Min',10,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .05 .9 .225],...
                            'Parent', spectro_optionsBgroup);


    % next button
    button_next;
    while nextb<=nextb_ref
        pause(0.1)
    end

    % extract values
    process_dir = logical(get(B_process_dir,'Value'));
    FileFilter = get(B_file_filter,'String');

    precalc_specrograms = logical(get(precalc_specrogramsB,'Value'));

    requested_num_markers_str = get(requested_num_markersB,'String');
    requested_num_markers = round(abs(str2double(requested_num_markers_str)));
    if isnan(requested_num_markers)
        requested_num_markers = 0;
    end
    requested_num_markers_str = num2str(requested_num_markers);

    num_marker_rows_str = get(num_marker_rowsB,'String');
    num_marker_rows = ceil(abs(str2double(num_marker_rows_str)));

    allow_textlabels = logical(get(allow_textlabelsB,'Value'));
    review_only = logical(get(review_onlyB,'Value'));
    
    nyquist_str = get(nyquistB,'String');
    nyquist = round(abs(str2double(nyquist_str)));
    if isnan(nyquist)
        nyquist = 5000;
    end
    nyquist_str = num2str(nyquist);
    Fs_spec = nyquist*2;

    premph_str = get(premphB,'String');
    premph = real(str2double(premph_str));
    if isnan(premph)
        premph = .95;
    end
    premph_str = num2str(premph);
    
    window_length_ms_str = get(window_length_msB,'String');
    window_length_ms = abs(str2double(window_length_ms_str));
    if isnan(window_length_ms)
        window_length_ms = 20;
    end
    window_length_ms_str = num2str(window_length_ms);

    window_shift_ms_str = get(window_shift_msB,'String');
    window_shift_ms = abs(str2double(window_shift_ms_str));
    if isnan(window_shift_ms) || window_shift_ms > window_length_ms - 1000/Fs_spec
        window_shift_ms = window_length_ms/10;
    end
    window_shift_ms_str = num2str(window_shift_ms);
    
    smooth_spectrograms = logical(get(smooth_spectroB,'Value'));

    colour_compression_str = get(colour_compressionB,'String');
    colour_compression = abs(str2double(colour_compression_str));
    if isnan(colour_compression) || colour_compression <= 0 || colour_compression >= 1
        colour_compression = .25;
    end
    colour_compression_str = num2str(colour_compression);
    
    spectro_colormap_index = get(spectro_colormap_indexB, 'Value');
    spectro_colormap = eval(colormap_options{spectro_colormap_index,2});
    
    
    % select the folder or individual file to load
    clf
    if process_dir
        [SoundFileName, SoundDir] = strtok(fliplr(FileFilter),'\');
        SoundFileName = fliplr(SoundFileName);
        SoundDir = fliplr(SoundDir);
        SoundDir_gotten = uigetdir(SoundDir,'Select the Folder Containing the Sound Files to Label');
    else
        [SoundFileName,SoundDir_gotten,FilterIndex] = uigetfile(FileFilter,'Select the Sound File to Label');
    end
    
    if SoundDir_gotten(1) ~= 0 && isempty(dir(fullfile(SoundDir_gotten,SoundFileName))) % make sure that the folder acotually contains files of the requested type
        SoundDir_gotten = 0;
    end
end
SoundDir = SoundDir_gotten;